package magazzino.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

import magazzino.Vettura;

public class DataWriter {

	private Vettura vettura;
	private String filename;
	private int[] quantity;
	private List<String> model;
	private int[] measure;
	private int[] days;
	private static final int MAX_DAYS = 3;

	public void setVettura(Vettura vettura) {
		this.vettura = vettura;
	}

	public void writeData() {

		// this.filename = vettura.getVettura();
		this.quantity = vettura.getQuantity();
		model = vettura.getModels();
		this.measure = vettura.getMeasure();
		this.days = vettura.getDay();

		try {

			FileWriter writer = new FileWriter(new File("vetture/" + filename
					+ ".txt"));
			
			FileWriter writer2 = new FileWriter(new File(
					"vetture/oldstocks.txt"));

			for (int i = 0; i < vettura.getQuantity().length; i++) {

				if (vettura.getQuantity()[i] == 0) {

				}

				writer.write(quantity[i] + " " + model.get(i) + "("
						+ measure[i] + ") " + (days[i] + 1) + "\n");

				if (vettura.getDay()[i] >= MAX_DAYS) {
					
					writer2.write("In " + filename + " ci sono ancora " + quantity[i] + " "
							+ model.get(i) + "(" + measure[i] + ") "
							+ (days[i]) + "\n");

				}

			}

			writer.close();
			writer2.close();

		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public void setQuantity(int[] quantity) {
		this.quantity = quantity;

	}

	public void setModel(List<String> model) {
		this.model = model;
	}

	public void setMeasure(int[] measure) {
		this.measure = measure;

	}

	public void setDay(int[] days) {
		this.days = days;
	}

	public void setFilename(String filename) {
		this.filename = filename;

	}

}
